package com.company.tp07_01_localtodoapp.view;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.ListView;

import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.AppCompatActivity;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;

import com.company.tp07_01_localtodoapp.R;
import com.company.tp07_01_localtodoapp.database.Todo;
import com.company.tp07_01_localtodoapp.view.adapter.TodoListAdapter;
import com.company.tp07_01_localtodoapp.viewmodel.TodoViewModel;

import java.util.ArrayList;
import java.util.List;

public class MainActivity extends AppCompatActivity {

    private static final String TAG = "TODO_APP";
    private ListView listView;
    private TodoListAdapter adapter;
    private TodoViewModel todoViewModel;


    ActivityResultLauncher<Intent> startAddTodoActivity = registerForActivityResult(new ActivityResultContracts.StartActivityForResult(),
            new ActivityResultCallback<ActivityResult>() {
                @Override
                public void onActivityResult(ActivityResult result) {
                    if (result.getResultCode() == Activity.RESULT_OK) {
                        Intent data = result.getData();
                        Todo todo = new Todo(1, data.getStringExtra(AddTodoActivity.EXTRA_REPLY));
                        todoViewModel.insert(todo);
                    }
                }
            });
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        Log.d(TAG, "onCreate start");
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        listView = (ListView) findViewById(R.id.listView);
        ViewModelProvider.AndroidViewModelFactory factory = ViewModelProvider.AndroidViewModelFactory.getInstance(this.getApplication());
        ViewModelProvider viewModelProvider = new ViewModelProvider(this, factory);
        todoViewModel = viewModelProvider.get(TodoViewModel.class);


        LiveData<List<Todo>> todoLiveData = todoViewModel.getTodoList();

        adapter = new TodoListAdapter(MainActivity.this, R.layout.list_item, new ArrayList<>());
        listView.setAdapter(adapter);

        todoLiveData.observe(this, new Observer<List<Todo>>() {
            @Override
            public void onChanged(List<Todo> todos) {
                adapter.setItems(todos);
                adapter.notifyDataSetChanged();
                Log.d(TAG, "Todo data reloaded");
            }
        });

        Log.d(TAG, "onCreate end");
    }
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_main, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id = item.getItemId();
        if (id == R.id.add) {
            Intent i = new Intent(getApplicationContext(),AddTodoActivity.class);
            startAddTodoActivity.launch(i);
            return true;
        }
        return super.onOptionsItemSelected(item);
    }
}